package gov.va.genisis2.model;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * The Class Source.
 * 
 * Description: In this Source Class implements the interface Serializable
 * and defines the entity and data mapping for the dbo.User_Approver Table in
 * the database.
 */
@Entity
@Table(name = "Source", schema = "dbo")
@XmlRootElement(name = "response")
@JsonIgnoreProperties({ "requests" })
public class Source implements java.io.Serializable {

	/**
	 * serialVersionUID field for serializable class
	 */
	private static final long serialVersionUID = 5135875868724790783L;

	/** The id. */
	private int id;
	
	/** The description. */
	private String description;
	
	/** The Requests */
	private Set<Request> requests = new HashSet<>(0);

	/**
	 * Instantiates a new source.
	 */
	public Source() {
		// Do nothing. The method is an intentionally-blank override.
	}

	/**
	 * Instantiates a new source.
	 *
	 * @param id the source entity id
	 */
	public Source(int id) {
		this.id = id;
	}
	/**
	 * Instantiates a new source.
	 *
	 * @param id the id
	 * @param description the description
	 * @param requests comment requests
	 */
	public Source(int id, String description, Set<Request> requests) {
		this.id = id;
		this.description = description;
		this.requests = requests;
	}

	/**
	 * Gets the id.
	 *
	 * @return the source id
	 */
	@Id
	@Column(name = "Id", unique = true, nullable = false)
	public int getId() {
		return this.id;
	}

	/**
	 * Sets the id.
	 *
	 * @param id the source id
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * Gets the description.
	 *
	 * @return the source description
	 */
	@Column(name = "Description", length = 50)
	public String getDescription() {
		return this.description;
	}

	/**
	 * Sets the description.
	 *
	 * @param description the source description
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	
	/** Gets request
	 * @return  Returns Request associated with the source
	 */
	@OneToMany(fetch=FetchType.LAZY, mappedBy="source")
    public Set<Request> getRequests() {
        return this.requests;
    }
    
	/**
	 * Sets the requests
	 *
	 * @param requests the requests
	 * 
	  */
    public void setRequests(Set<Request> requests) {
        this.requests = requests;
    }
    
}
